PrefabFiles = {
	"tobiichiorigami",
	"lightsword",
	"cz83",
	"sm68",
	"cz830",
	"cz83cile",
	"millbuilder",
	"coherer_small",
	"coherer",
	"shidao",
	"fe",
	"c",
	"cu",
	"ast",
	"cuaxe",
	"feaxe",
	"fepickaxe",
	"cupickaxe",
	"huhu",
	"wokertable",
	"ast_sr_boards",
	"ast_r_cz83",
	"ast_n_gears",
	"cr_unit",
	"fibre",
	"monstermetal",
	"culine",
	"tendon",
	"garbage",
	"dna",
	"pb",
	"cell",
	"tsilk",
	"leather",
	"plant",
	"gene",
	"ast_seeds",
	"glass",
	"sand",
	"wheat",
	"guzhu",
	"maizi",
	"guzhuguo",
	"firemine",
	"sunmine",
	"firestone",
	"moonghost",
	"moonmonster",
	"vendingmachine",
	"earlkeith",
	"sell",
	"ast_info",
	"unknow",
	"foodworktable",
	"knife",
	"cuisine",
	"bottle",
	"cumine",
	"crunitcr",
	"ast_item",
	"ast_item_2",
	"magicpower",
	"tujian",
	"compressor",
	"condense",
	"magicpower_mk2",
	"wood",
	"bmachineshell",
	"unit_center",
	"millbox",
	"treebox",
	"tree",
	"worktable",
	"soul",
	"magicbox",
	"firehammer",
	"aoruisword",
	"bosssword",
	"hatbag",
	"swordtx",
	"lightsword_sk",
	"hpup",
	"ast_item",
	"culine",
	"farm",
	"astlight",
	"astfurnace",
	"astchest",
	"aspirator",
	"bottle",
	"study",
	"ast_item_2",
	"ast_card",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/tobiichiorigami.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/tobiichiorigami.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/tobiichiorigami.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/tobiichiorigami.xml" ),

    Asset( "IMAGE", "bigportraits/tobiichiorigami.tex" ),
    Asset( "ATLAS", "bigportraits/tobiichiorigami.xml" ),
	
	Asset( "IMAGE", "images/map_icons/tobiichiorigami.tex" ),
	Asset( "ATLAS", "images/map_icons/tobiichiorigami.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_tobiichiorigami.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_tobiichiorigami.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_tobiichiorigami.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_tobiichiorigami.xml" ),
	
    Asset( "IMAGE", "bigportraits/tobiichiorigami.tex" ),
    Asset( "ATLAS", "bigportraits/tobiichiorigami.xml" ),

	Asset( "IMAGE", "images/AST.tex" ),
    Asset( "ATLAS", "images/AST.xml" ),
	Asset( "ATLAS", "images/rabbitwheel.xml" ),
	Asset( "ATLAS", "images/ast0.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/cz830.tex" ),
    Asset( "ATLAS", "images/inventoryimages/cz830.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/cz83cile.tex" ),
    Asset( "ATLAS", "images/inventoryimages/cz83cile.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/coherer_small.tex" ),
    Asset( "ATLAS", "images/inventoryimages/coherer_small.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/coherer.tex" ),
    Asset( "ATLAS", "images/inventoryimages/coherer.xml" ),
	
	Asset( "ATLAS", "images/astwidgets/ast_0.xml" ),
	Asset("ANIM", "anim/ui_tujian_3x3.zip"),
	
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS
local Ingredient = GLOBAL.Ingredient
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH
local SpawnPrefab = GLOBAL.SpawnPrefab
local Vector3 = GLOBAL.Vector3
modimport "scripts/tounewtree.lua"
AddNewTechTree("TOU_FARM",3)
AddNewTechTree("TOU_ASTITEM",3)
AddNewTechTree("TOU_STUDY",3)
--mod内容
STRINGS.CHARACTER_TITLES.tobiichiorigami = "TobiichiOrigami"
STRINGS.CHARACTER_NAMES.tobiichiorigami = "origami"
STRINGS.CHARACTER_DESCRIPTIONS.tobiichiorigami = "*随意领域，展开！\n*恋慕的纸鹤，为你而折\n*因为是数据体，个头有点小"
STRINGS.CHARACTER_QUOTES.tobiichiorigami = "\"奇迹是用指尖捏造的事物\""
STRINGS.NAMES.LIGHTSWORD = "AST标准光剑"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIGHTSWORD= "AST部队标配"
STRINGS.NAMES.CZ83 = "捷克cz83"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CZ83= "捷克cz83手枪，使用9毫米勃朗宁短弹及多种弹药，采用10双排弹匣供弹机构，有效射程50米。"
STRINGS.NAMES.SM68 = "M68式手榴弹"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SM68= "米国军队标准配置，但是对精灵部队依然使用显现装置"
STRINGS.NAMES.CZ830 = "捷克cz83-空弹"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CZ830= "我需要给他填充子弹"
STRINGS.NAMES.CZ83CILE = "cz83的弹夹"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CZ83CILE= "给手枪提供弹药"
STRINGS.NAMES.COHERER = "大块金属"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.COHERER= "这玩意是合金，大概。"
STRINGS.NAMES.COHERER_SMALL = "金属碎片"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.COHERER_SMALL= "太少了，没法使用"
STRINGS.NAMES.MILLBUILDER = "研磨器"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MILLBUILDER= "我应该将各种物质送进去分解一下,这个型号具有自动捡拾叠加功能"
STRINGS.NAMES.SHIDAO = "士道的橡皮擦"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHIDAO= "趁上次给士道捡橡皮擦时用新橡皮擦替换的 \n 士道的味道。。。。"
STRINGS.NAMES.FE = "铁块"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FE= "这里的燧石含这个吗？"
STRINGS.NAMES.C = "碳"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.C= "不知道能不能作为燃料"
STRINGS.NAMES.CU = "铜块"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CU= "很常见的金属，而且还能导电"
STRINGS.NAMES.AST = "AST宇宙计划报告书"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST= " "
STRINGS.NAMES.CUAXE = "铜制斧子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CUAXE= "它的效率和它的耐久刚好相反"
STRINGS.NAMES.FEAXE = "铁制斧子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FEAXE= "虽然没法打磨，但是很耐用"
STRINGS.NAMES.FEPICKAXE = "铁制镐子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FEPICKAXE= "非常耐用的镐子"
STRINGS.NAMES.CUPICKAXE = "铜制镐子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CUPICKAXE= "如果它再结实点，就是最好的镐子了"
STRINGS.NAMES.HUHU = "营养糊"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HUHU= "它很有营养，但是我绝对不会去吃的"
STRINGS.NAMES.WOKERTABLE = "改造台"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WOKERTABLE= " "
STRINGS.NAMES.AST_SR_BOARDS = "鸢一折纸-sr指令-Boards"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_SR_BOARDS= "非消耗性指令卡，消耗木材6 获取木板1"
STRINGS.NAMES.AST_R_CZ83 = "鸢一折纸-r指令-Cz83"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_R_CZ83= "消耗性指令卡，消耗金子12 石材24 获取cz83手枪1"
STRINGS.NAMES.AST_N_GEARS = "鸢一折纸-n指令-Gears"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_N_GEARS= "消耗性指令卡，消耗金子8 石材12 获取齿轮1"
STRINGS.NAMES.CR_UNIT = "基础显现装置"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CR_UNIT= "调用出AST制式采用装备，因为是便携时，所以对身体有损伤"
STRINGS.NAMES.FIBRE = "植物纤维"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FIBRE= "植物的粗纤维，但是这种和薯类不同，不能食用。"
STRINGS.NAMES.MONSTERMETAL = "怪物金属"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MONSTERMETAL= "使用怪物肉中的废料和金属结合，具有极佳的附着性，可以制作AST计划必须的指令卡。"
STRINGS.NAMES.CULINE = "铜线"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CULINE= "具有很好的导电性，重要性不用我说"
STRINGS.NAMES.TENDON = "肉筋"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TENDON= "过于坚韧，无法食用"
STRINGS.NAMES.GARBAGE = "怪物废料"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GARBAGE= "研磨怪兽肉得到的垃圾，就是因为这东西怪兽肉才不可食用。"
STRINGS.NAMES.DNA = "遗传物质"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DNA= "我在用手拿着它？"
STRINGS.NAMES.PB = "铅"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PB= "重金属，有毒，可以防辐射"
STRINGS.NAMES.CELL = "细胞材料"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CELL= "植物细胞。。。我居然拿在手上？"
STRINGS.NAMES.LEATHER = "皮革"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LEATHER= "既不是猪皮也不是牛皮"
STRINGS.NAMES.TSILK = "真丝纤维"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TSILK= "这个世界没有绿毛虫"
STRINGS.NAMES.PLANT = "植物研究台"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PLANT= "用于将植物的基因提取出来,还能用基因解锁植物种子"
STRINGS.NAMES.GENE_DIKANG = "抵抗基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_DIKANG= "一种基因。。含有这种基因的植物比较顽强 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_KUNCHONG = "昆虫基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_KUNCHONG= "一种基因。。含有这种基因的植物可以像昆虫一样行动 \n等等我在拿着它？"
STRINGS.NAMES.GENE_DUXING = "毒性基因" 
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_DUXING= "一种基因。。含有这种基因的植物都有些许毒素 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_FAGUANG = "发光基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_FAGUANG= "一种基因。。含有这种基因的植物都能发出微弱的光 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_FUSHI = "腐蚀基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_FUSHI= "一种基因。。含有这种基因的植物都带些许腐蚀性\n 等等我在拿着它？"
STRINGS.NAMES.GENE_GUANGXUE = "光学基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_GUANGXUE= "一种基因。。含有这种基因的植物都可以改变光线反射和折射\n 等等我在拿着它？"
STRINGS.NAMES.GENE_LUOXUAN = "LUOXUAN基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_LUOXUAN= "一种比较常见的基因 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_MIANYI = "免疫基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_MIANYI= "一种基因。。含有这种基因的植物都免疫毒素或者别的东西\n 等等我在拿着它？"
STRINGS.NAMES.GENE_MINJIE = "敏捷基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_MINJIE= "一种基因。。含有这种基因的植物可以发生相对来说快速的行为 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_NENGLIANG = "能量基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_NENGLIANG= "一种基因。。含有这种基因的植物都富含卡路里 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_SHUISU = "水份基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_SHUISU= "一种基因。。含有这种基因的植物都含有不少的水分 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_XUKONG = "虚空基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_XUKONG= "一种基因。。。士道？。。爸爸妈妈？"
STRINGS.NAMES.GENE_YELVSU = "叶绿素基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_YELVSU= "一种基因。。大多数绿色植物都含有这种基因 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_ZAISHENG = "再生基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_ZAISHENG= "一种基因。。含有这种基因的植物吃下后可以促进身体血液循环，让伤口快速恢复 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_ZISHIYING = "自适应基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_ZISHIYING= "一种基因。。含有这种基因的植物都有较强的环境适应力 \n 等等我在拿着它？"
STRINGS.NAMES.GENE_GUGE = "骨骼基因"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENE_GUGE= "一种基因。。含有这种基因的植物会有类似骨骼的节奏 \n 等等我在拿着它？"
STRINGS.NAMES.SEED_BERRYBUSH_JUICY = "多汁浆果种子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEED_BERRYBUSH_JUICY = "这是一颗种子"
STRINGS.NAMES.SEED_REEDS = "芦苇种子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEED_REEDS = "通过基因工程改良的芦苇，可以生长在大多数地形。。。等等基因工程？"
STRINGS.NAMES.SAND = "沙子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SAND = "高温下其中的硅会凝结为玻璃"
STRINGS.NAMES.GLASS = "玻璃"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GLASS = "这是一坨玻璃，我还能加工吗？"
STRINGS.NAMES.SEED_WHEAT = "小麦种子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEED_WHEAT = "这种经过基因改良的小麦有很快的生长速度，可惜的是它长出来的麦粒不能用于播种"
STRINGS.NAMES.WHEAT = "麦子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WHEAT = "麦子，单子叶植物，禾本科，因为经过基因改造可以重复生长"
STRINGS.NAMES.MAIZI = "麦穗"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAIZI = "转基因麦子，我最好磨成粉食用"
STRINGS.NAMES.GUZHU = "骨竹"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GUZHU = "骨竹，多年生禾本科竹亚科多肉植物，为了恐吓动物长得很吓人，实际上只能吓人"
STRINGS.NAMES.GUZHUGUO = "骨竹果"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GUZHUGUO = "骨竹果，味道和牛肉相似，蛋白质是人脑的六倍。。。。我不想吃它"
STRINGS.NAMES.FIRESTONE = "永燃岩"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FIRESTONE = "其中含有日曜矿和永燃矿，但是它很结实，高温下进行长时间挖掘作业要注意。"
STRINGS.NAMES.MOONMONSTER = "月怪"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MOONMONSTER = "士道说过，精灵是可以沟通的，但是它们，只有战斗这一种选择！"
STRINGS.NAMES.VENDINGMACHINE = "售货机"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.VENDINGMACHINE = ""
STRINGS.NAMES.EARLKEITH = "厄尔吉斯晶体"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.EARLKEITH = "这是AST总部需要的，我可以用它向总部购买物资"
STRINGS.NAMES.SELL = "售货机2000x"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SELL = "这是在AST总部常见的老式售货机，不过货币被改为只识别厄尔吉斯晶体"
STRINGS.NAMES.SANDINFO = "沙子 \n 研磨沙漠地皮，研磨砂砾获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SANDINFO = "可以用于制造玻璃，研磨出硅"
STRINGS.NAMES.SUNMINE = "日曜矿"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUNMINE = "摸上去它就像阳光一样温暖"
STRINGS.NAMES.SUNMINEINFO = "日曜矿 \n 挖掘每年夏天在岩浆池旁边出生一次的永燃岩获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUNMINEINFO = "可以用于制造日曜装备，合成新的合金"
STRINGS.NAMES.GLASSINFO = "玻璃 \n 用高温处理沙子获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GLASSINFO = "可以用于制造一些设备，还有一些玻璃制品"
STRINGS.NAMES.TSILKINFO = "真丝纤维 \n 用研磨器提纯蜘蛛丝或者提取蜘蛛腺体获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TSILKINFO = "非常棒的纺织物材料，可以做一些漂亮的装备"
STRINGS.NAMES.DNAINFO = "遗传物质 \n 用研磨器研磨肉类获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DNAINFO = "可以用于制作一些生物上的实验"
STRINGS.NAMES.LEATHERINFO = "皮革 \n 用研磨器研磨大肉获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LEATHERINFO = "是一些武器以及衣服的材料"
STRINGS.NAMES.GARBAGEINFO = "怪物废料 \n 用研磨器研磨怪兽肉类获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GARBAGENFO = "可以配置毒水，制作怪物金属等"
STRINGS.NAMES.TENDONINFO = "肉筋 \n 用研磨器大肉和怪兽肉获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TENDONINFO = "可以用于制作一些生物武器"
STRINGS.NAMES.COHERERINFO = "大块金属 \n 用研磨器研磨金块或用金属碎片拼合获得"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.COHERERINFO = "可以用于制作一些机器设备，也能研磨出一些金属"
STRINGS.NAMES.AST_INFO = "AST宇宙计划材料百科"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_INFO = "需要什么材料的时候看看吧"
STRINGS.NAMES.KNIFE = "砍刀"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.KNIFE = "武器，还是厨具？"
STRINGS.NAMES.SMALLBONESTEW = "小肉汤"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SMALLBONESTEW = "出乎意料的可以填满肚子"
STRINGS.NAMES.UNDERBOILED_KABOBS = "生肉串"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.UNDERBOILED_KABOBS = "我觉得我应该烤熟了吃"
STRINGS.NAMES.DOUGH = "面团"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DOUGH = "面粉和水按照精确比例和面得到"
STRINGS.NAMES.FLOUR = "面粉"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FLOUR = "精制小麦粉，大多数料理的必备材料"
STRINGS.NAMES.WATER = "水"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FLOUR = "这是一单位水，在显现装置的效果下接近固态了"
STRINGS.NAMES.BOTTLE = "瓶子"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOTTLE = "我应该灌满它"
STRINGS.NAMES.BOTTLE_WATER = "水瓶"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOTTLE_WATER = "我能用显现装置处理其中的水，但是我不能抵抗潮湿？"
STRINGS.NAMES.FOODWORKTABLE = "料理台"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FOODWORKTABLE = "有了它和烹饪锅我就可以暂时不为吃的发愁了"
STRINGS.NAMES.CUMINE = "兔能挖矿机"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CUMINE = "只需要一根胡萝卜就能让这小家伙干一天活"
STRINGS.NAMES.MAGICPOWER = "魔力"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAGICPOWER= "迷一样的物质"
STRINGS.NAMES.CRUNITCR = "显现装置cr型"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CRUNITCR= "改良后的用于生成创造和改变物质魔力的显现装置"
STRINGS.NAMES.CR_UNIT = "基础显现装置便携式"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CR_UNIT= "可携带式的防御型显现装置，AST的标准配置，使用时对身体有一定负荷"
STRINGS.NAMES.COMPRESSOR = "压缩机"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.COMPRESSOR= "可以压缩干草，树枝，金块，燧石岩石硝石还有，魔力"
STRINGS.NAMES.MAGICPOWER_MK2 = "纯净魔力"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAGICPOWER_MK2= "大量魔力压缩得到的纯净魔力"
STRINGS.NAMES.WOOD = "木材"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WOOD= "将一堆木头压缩起来"
STRINGS.NAMES.CONDENSE_ROCK = "压缩岩石"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CONDENSE_ROCK= "这是40单位的岩石"
STRINGS.NAMES.CONDENSE_FLINT = "压缩燧石"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CONDENSE_FLINT= "这是40单位的燧石"
STRINGS.NAMES.CONDENSE_CUTGRASS = "压缩干草"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CONDENSE_CUTGRASS= "这是40单位的干草"
STRINGS.NAMES.CONDENSE_NITRE = "压缩硝石"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CONDENSE_NITRE= "这是40单位的硝石"
STRINGS.NAMES.CONDENSE_GOLDNUGGET = "压缩黄金"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CONDENSE_GOLDNUGGET= "这是20单位的金块"
STRINGS.NAMES.CONDENSE_TWIGS = "压缩树枝"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CONDENSE_TWIGS= "这是40单位的树枝"
STRINGS.NAMES.BMACHINESHELL = "基础机器外壳"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BMACHINESHELL= "大部分机器都需要的部件"
STRINGS.NAMES.UNIT_CENTER = "显现装置核心"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.UNIT_CENTER= "unit必须的材料"
STRINGS.NAMES.MILLBOX = "分解器"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MILLBOX= "把压缩出来的东西还原"
STRINGS.NAMES.TREEBOX = "树箱"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TREEBOX= "更高效的加工木板以及改造树种"
STRINGS.NAMES.TREESEED = "AST树种"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TREESEED= "经过魔力处理的树种，生长速度更快"
STRINGS.NAMES.TREE = "平凡的树"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TREE= "木头的最佳来源"
STRINGS.NAMES.WORKTABLE = "研究台"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WORKTABLE= " "
STRINGS.NAMES.SOUL = "本质的来生"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SOUL= "它既是死的又是活的，既是万物之初始又是万物之终结，它是一撮灵魂"
STRINGS.NAMES.LIGHTSWORD_SK = "AST特种光剑-sk型"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIGHTSWORD_SK= "这是为了让使用者更加容易与精灵缠斗所发明的"
STRINGS.NAMES.HPUP = "血量回复剂"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HPUP= "它最大的优点大概就是可以长久保存了吧"
STRINGS.NAMES.MAGICBOX = "魔力汲取器"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAGICBOX= "耐心等待，使用电刺激生成魔力是很消耗时间的"
STRINGS.NAMES.AST_AI = "智能芯片"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_AI= "嗨多磨"
STRINGS.NAMES.AST_CPU = "cr处理器"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_CPU= "由图拉丁集团提供技术制造"
STRINGS.NAMES.AST_BOARD = "金属板"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_BOARD= "用魔力处理后就可以作为电路板使用了"
STRINGS.NAMES.AST_CIRCUIT_BOARD = "电路板"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_CIRCUIT_BOARD= "它是应用在魔力领域的"
STRINGS.NAMES.AST_FOCUS = "聚焦阵列"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_FOCUS= "将魔力聚焦从而得到更为持久的能源"
STRINGS.NAMES.AST_GEARS = "精密齿轮"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_GEARS= "虽然看上去不太精密，但请相信它的细致性"
STRINGS.NAMES.AST_MEMORYBANK = "内存条"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_MEMORYBANK= "请放下，不要插进你的笔记本里，这是公家的财产"
STRINGS.NAMES.COIL = "电磁线圈"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.COIL= "中间插入芯柱通电也许可以当电磁铁？"
STRINGS.NAMES.SEAWEED = "海带"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEAWEED= "一种水生藻类"
STRINGS.NAMES.LIMPETS = "帽贝"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIMPETS= "海边岩石上的常见贝类"
STRINGS.NAMES.SEAWEED_COOKED = "烤海带"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEAWEED_COOKED= "烤熟后味道好多了"
STRINGS.NAMES.LIMPETS_COOKED = "烤帽贝"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LIMPETS_COOKED= "熟了之后总算不腥了"
STRINGS.NAMES.BMACHINESHELLEX = "高级机器基础外壳"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BMACHINESHELLEX= "可以制作更加复杂的机器"
--配方介绍
STRINGS.RECIPE_DESC.CZ83   = "其实只是在装子弹"
STRINGS.RECIPE_DESC.CZ83CILE   = "显现装置使这些东西变成子弹了"
STRINGS.RECIPE_DESC.MILLBUILDER   = "AST宇宙计划的基础中的基础"
STRINGS.RECIPE_DESC.COHERER   = "一大块金属混合物"
STRINGS.RECIPE_DESC.COHERER_SMALL   = "用研磨器比用手强"
STRINGS.RECIPE_DESC.CUAXE   = "不耐用，但是很锋利的斧子"
STRINGS.RECIPE_DESC.FEAXE   = "老铁，这东西绝对比石头好"
STRINGS.RECIPE_DESC.CUPICKAXE   = "只要两下你就能敲碎岩石！"
STRINGS.RECIPE_DESC.FEPICKAXE   = "金子那么贵，为什么不试试铁的呢？"
STRINGS.RECIPE_DESC.WOKERTABLE   = "AST计划的重要设施之一，你可以储存物品"
STRINGS.RECIPE_DESC.MONSTERMETAL   = "将生物和金属结合"
STRINGS.RECIPE_DESC.CULINE   = "铜线的重要性不用多说吧"
STRINGS.RECIPE_DESC.AST_N_GEARS   = "这张卡片内自带显现装置，可以转换材料"
STRINGS.RECIPE_DESC.AST_R_CZ83   = "可以将这把枪交给其他人使用"
STRINGS.RECIPE_DESC.AST_SR_BOARDS   = "木材换木板？很划算"
STRINGS.RECIPE_DESC.CR_UNIT   = "目前为止我最强的武器"
STRINGS.RECIPE_DESC.SEED_BERRYBUSH_JUICY   = "种植果实饱满但是生长缓慢的多汁浆果"
STRINGS.RECIPE_DESC.SEED_REEDS   = "将这种沼泽植物改良为可以随地种植"
STRINGS.RECIPE_DESC.SEED_CACTUS  = "不想让这种坚韧的植物长遍大地吗？"
STRINGS.RECIPE_DESC.SEED_WHEAT   = "小麦既是正义！粮食就是正义！"
STRINGS.RECIPE_DESC.SEED_WORMLIGHT_PLANT   = "经过改良后这种植物已经不怕阳光了"
STRINGS.RECIPE_DESC.PLANT   = "提取植物的基因并合成新植物，我以为这需要更严谨的机器的"
STRINGS.RECIPE_DESC.SELL   = "AST总部常见的售货机，可以升级"
STRINGS.RECIPE_DESC.BOTTLE   = "如你所见，这是个可以装水的瓶子"
STRINGS.RECIPE_DESC.FOODWORKTABLE   = "高效的料理方式"
STRINGS.RECIPE_DESC.CUMINE  = "虽然不是仓鼠，但是兔子跑轮也不错"
STRINGS.RECIPE_DESC.BMACHINESHELL  = "大部分机器最重要的外壳和皮肤"
STRINGS.RECIPE_DESC.TREEBOX  = "为了快速获取木头的必要设施"
STRINGS.RECIPE_DESC.UNIT_CENTER  = "显现装置的重中之重"
--全局物品制作
function load()
--铜斧
 local cuaxe = GLOBAL.Recipe("cuaxe", {Ingredient("twigs", 2),Ingredient("cu", 1,"images/inventoryimages/cu.xml", "cu.tex")}, RECIPETABS.TOOLS, {SCIENCE=1})
 cuaxe.atlas = "images/inventoryimages/cuaxe.xml"
 cuaxe.image = "cuaxe.tex"
--铜镐
 local cupickaxe = GLOBAL.Recipe("cupickaxe", {Ingredient("twigs", 3),Ingredient("cu", 2,"images/inventoryimages/cu.xml", "cu.tex")}, RECIPETABS.TOOLS, {SCIENCE=2})
 cupickaxe.atlas = "images/inventoryimages/cupickaxe.xml"
 cupickaxe.image = "cupickaxe.tex"
 --铁镐
 local fepickaxe = GLOBAL.Recipe("fepickaxe", {Ingredient("twigs", 3),Ingredient("fe", 2,"images/inventoryimages/fe.xml", "fe.tex")}, RECIPETABS.TOOLS, {SCIENCE=2})
 fepickaxe.atlas = "images/inventoryimages/fepickaxe.xml"
 fepickaxe.image = "fepickaxe.tex"
 --铁斧
 local feaxe = GLOBAL.Recipe("feaxe", {Ingredient("twigs", 2),Ingredient("fe", 1,"images/inventoryimages/fe.xml", "fe.tex")}, RECIPETABS.TOOLS, {SCIENCE=1})
 feaxe.atlas = "images/inventoryimages/feaxe.xml"
 feaxe.image = "feaxe.tex"
 --怪物金属
 local monstermetal = GLOBAL.Recipe("monstermetal", {Ingredient("fe", 2,"images/inventoryimages/fe.xml", "fe.tex"),Ingredient("garbage", 1,"images/inventoryimages/garbage.xml", "garbage.tex"),Ingredient("culine", 4,"images/inventoryimages/culine.xml", "culine.tex")}, RECIPETABS.REFINE, {SCIENCE=2})
 monstermetal.atlas = "images/inventoryimages/monstermetal.xml"
 monstermetal.image = "monstermetal.tex"
--售货机2000x
 local sell = GLOBAL.Recipe("sell", {Ingredient("culine", 2,"images/inventoryimages/culine.xml", "culine.tex"),Ingredient("goldnugget", 1),Ingredient("fibre", 1,"images/inventoryimages/fibre.xml", "fibre.tex")}, RECIPETABS.TOWN, {SCIENCE=0})
 sell.atlas = "images/inventoryimages/vendingmachine.xml"
 sell.image = "vendingmachine.tex"
end
load()
--专属科技栏
ITEMtab = AddRecipeTab("基础科技",233, "images/rabbitwheel.xml", "rabbitwheel.tex", "item_builder")
DEMtab = AddRecipeTab("DEM科技",233, "images/AST.xml", "AST.tex", "ast_builder")
LIVEtab = AddRecipeTab("Phantom科技",233, "images/rabbitwheel.xml", "rabbitwheel.tex", "live_builder")
ASTtab = AddRecipeTab("AST",233, "images/ast0.xml", "ast0.tex", "ast_builder")
--配方
--cz83装弹
local cz83 = AddRecipe("cz83",
{Ingredient("cz830", 1,"images/inventoryimages/cz830.xml", "cz830.tex"),Ingredient("cz83cile", 1,"images/inventoryimages/cz83cile.xml", "cz83cile.tex")},
ITEMtab, TECH.NONE,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/cz83.xml", "cz83.tex")
--cz83弹药
local cz83cile = AddRecipe("cz83cile",
{Ingredient("nitre", 3),Ingredient("coherer", 1,"images/inventoryimages/coherer.xml", "coherer.tex")},
ITEMtab, TECH.NONE,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/cz83cile.xml", "cz83cile.tex")
--研磨器
local millbuilder = AddRecipe("millbuilder",
{Ingredient("rope", 1),Ingredient("goldnugget", 1),Ingredient("boards", 2),Ingredient("hammer", 1)},
ITEMtab,TECH.SCIENCE_ONE,
"millbuilder_placer", 1.5, nil, nil, "ast_builder",
"images/inventoryimages/millbuilder.xml", "millbuilder.tex")
--改造台
local wokertable = AddRecipe("wokertable",
{Ingredient("rope", 1),Ingredient("goldnugget", 3),Ingredient("boards", 2),Ingredient("cutstone", 4)},
ITEMtab,TECH.SCIENCE_ONE,
"wokertable_placer", 2.5, nil, nil, "ast_builder",
"images/inventoryimages/wokertable.xml", "wokertable.tex")
--植物研究台
local plant = AddRecipe("plant",
{Ingredient("glass", 1,"images/inventoryimages/glass.xml", "glass.tex"),Ingredient("coherer", 3,"images/inventoryimages/coherer.xml", "coherer.tex"),Ingredient("boards", 4),Ingredient("transistor", 2)},
ITEMtab,TECH.SCIENCE_ONE,
"plant_placer", 3, nil, nil, "ast_builder",
"images/inventoryimages/plant.xml", "plant.tex")
--大块金属
local coherer = AddRecipe("coherer",
{Ingredient("coherer_small", 2,"images/inventoryimages/coherer_small.xml", "coherer_small.tex")},
ITEMtab, TECH.NONE,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/coherer.xml", "coherer.tex")
--金属碎片
local coherer_small = AddRecipe("coherer_small",
{Ingredient("flint", 2)},
ITEMtab, TECH.SCIENCE_ONE,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/coherer_small.xml", "coherer_small.tex")
--指令卡-n-齿轮
local ast_n_gears = AddRecipe("ast_n_gears",
{Ingredient("monstermetal", 1,"images/inventoryimages/monstermetal.xml", "monstermetal.tex"),Ingredient("goldnugget", 3),Ingredient("culine", 1,"images/inventoryimages/culine.xml", "culine.tex")},
ASTtab, TECH.SCIENCE_ONE,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/ast_n_gears.xml", "ast_n_gears.tex")
--指令卡-r-cz83
local ast_r_cz83 = AddRecipe("ast_r_cz83",
{Ingredient("monstermetal", 1,"images/inventoryimages/monstermetal.xml", "monstermetal.tex"),Ingredient("cz83cile", 3,"images/inventoryimages/cz83cile.xml", "cz83cile.tex")},
ASTtab, TECH.SCIENCE_ONE,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/ast_r_cz83.xml", "ast_r_cz83.tex")
--指令卡-sr-木板
local ast_sr_boards = AddRecipe("ast_sr_boards",
{Ingredient("monstermetal", 1,"images/inventoryimages/monstermetal.xml", "monstermetal.tex"),Ingredient("boards", 3)},
ASTtab, TECH.SCIENCE_TWO,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/ast_sr_boards.xml", "ast_sr_boards.tex")

--便携式显现装置
local cr_unit = AddRecipe("cr_unit",
{Ingredient("monstermetal", 4,"images/inventoryimages/monstermetal.xml", "monstermetal.tex"),Ingredient("fe", 4,"images/inventoryimages/fe.xml", "fe.tex"),Ingredient("culine", 4,"images/inventoryimages/culine.xml", "culine.tex"),Ingredient("goldnugget", 10)},
ITEMtab, TECH.SCIENCE_TWO,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/cr_unit.xml", "cr_unit.tex")
--瓶子
local bottle = AddRecipe("bottle",
{Ingredient("glass", 2,"images/inventoryimages/glass.xml", "glass.tex")},
ITEMtab, TECH.SCIENCE_TWO,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/bottle.xml", "bottle.tex")
--兔能挖矿机
local cumine = AddRecipe("cumine",
{Ingredient("rope", 1),Ingredient("cu", 10,"images/inventoryimages/cu.xml", "cu.tex"),Ingredient("rabbit", 1),Ingredient("cutstone", 4)},
ITEMtab,TECH.SCIENCE_ONE,
"cumine_placer", 2.5, nil, nil, "ast_builder",
"images/inventoryimages/rabbitwheel.xml", "rabbitwheel.tex")
--种子系列
 --多汁浆果种子
 local seed_berrybush_juicy = AddRecipe("seed_berrybush_juicy",
{Ingredient("seeds", 1),Ingredient("gene_luoxuan", 2,"images/inventoryimages/gene_luoxuan.xml", "gene_luoxuan.tex"),Ingredient("huhu", 16,"images/inventoryimages/huhu.xml", "huhu.tex"),Ingredient("gene_zishiying", 2,"images/inventoryimages/gene_zishiying.xml", "gene_zishiying.tex")},
ASTtab, TECH.TOU_FARM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/seed_berrybush_juicy.xml", "seed_berrybush_juicy.tex")
--芦苇种子
 local seed_reeds = AddRecipe("seed_reeds",
{Ingredient("seeds", 1),Ingredient("gene_yelvsu", 2,"images/inventoryimages/gene_yelvsu.xml", "gene_yelvsu.tex"),Ingredient("huhu", 6,"images/inventoryimages/huhu.xml", "huhu.tex"),Ingredient("gene_zishiying", 4,"images/inventoryimages/gene_zishiying.xml", "gene_zishiying.tex")},
ASTtab, TECH.TOU_FARM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/seed_reeds.xml", "seed_reeds.tex")
--麦子种子
 local seed_wheat = AddRecipe("seed_wheat",
{Ingredient("seeds", 1),Ingredient("gene_nengliang", 2,"images/inventoryimages/gene_nengliang.xml", "gene_nengliang.tex"),Ingredient("huhu", 6,"images/inventoryimages/huhu.xml", "huhu.tex"),Ingredient("gene_zishiying", 4,"images/inventoryimages/gene_zishiying.xml", "gene_zishiying.tex")},
ASTtab, TECH.TOU_FARM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/seed_wheat.xml", "seed_wheat.tex")
--仙人掌种子
 local seed_cactus = AddRecipe("seed_cactus",
{Ingredient("seeds", 1),Ingredient("gene_dikang", 1,"images/inventoryimages/gene_dikang.xml", "gene_dikang.tex"),Ingredient("huhu", 6,"images/inventoryimages/huhu.xml", "huhu.tex"),Ingredient("gene_shuisu", 2,"images/inventoryimages/gene_shuisu.xml", "gene_shuisu.tex")},
ASTtab, TECH.TOU_FARM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/seed_cactus.xml", "seed_cactus.tex")
--发光浆果种子
 local seed_cactus = AddRecipe("seed_wormlight_plant",
{Ingredient("seeds", 1),Ingredient("gene_faguang", 1,"images/inventoryimages/gene_faguang.xml", "gene_faguang.tex"),Ingredient("huhu", 6,"images/inventoryimages/huhu.xml", "huhu.tex"),Ingredient("gene_shuisu", 2,"images/inventoryimages/gene_shuisu.xml", "gene_shuisu.tex")},
ASTtab, TECH.TOU_FARM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/seed_wormlight_plant.xml", "seed_wormlight_plant.tex")
--树箱
local treebox = AddRecipe("treebox",
{Ingredient("bmachineshell", 1,"images/inventoryimages/bmachineshell.xml", "bmachineshell.tex"),Ingredient("ast_ai", 1,"images/inventoryimages/ast_ai.xml", "ast_ai.tex"),Ingredient("unit_center", 1,"images/inventoryimages/unit_center.xml", "unit_center.tex"),Ingredient("cutstone", 4)},
ITEMtab,TECH.SCIENCE_ONE,
"treebox_placer", 2.5, nil, nil, "ast_builder",
"images/inventoryimages/treebox.xml", "treebox.tex")
--基础机器外壳
 local bmachineshell = AddRecipe("bmachineshell",
{Ingredient("coherer", 3,"images/inventoryimages/coherer.xml", "coherer.tex"),Ingredient("goldnugget", 1),Ingredient("magicpower", 2,"images/inventoryimages/magicpower.xml", "magicpower.tex")},
ITEMtab, TECH.TOU_ASTITEM_TWO,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/bmachineshell.xml", "bmachineshell.tex")
--显现装置核心
 local unit_center = AddRecipe("unit_center",
{Ingredient("goldnugget", 3),Ingredient("pb", 1,"images/inventoryimages/pb.xml", "pb.tex"),Ingredient("magicpower", 15,"images/inventoryimages/magicpower.xml", "magicpower.tex")},
ITEMtab, TECH.TOU_ASTITEM_TWO,
nil, nil, nil, nil, "ast_builder",
"images/inventoryimages/unit_center.xml", "unit_center.tex")
--机械零件
--精密齿轮
local ast_gears = AddRecipe("ast_gears",
{Ingredient("goldnugget", 2)},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_gears.xml", "ast_gears.tex")
--金属板
local ast_board = AddRecipe("ast_board",
{Ingredient("goldnugget", 1),Ingredient("cu", 5,"images/inventoryimages/cu.xml", "cu.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_board.xml", "ast_board.tex")
--数据板
local ast_circuit_board = AddRecipe("ast_circuit_board",
{Ingredient("magicpower", 5,"images/inventoryimages/magicpower.xml", "magicpower.tex"),Ingredient("ast_board", 1,"images/inventoryimages/ast_board.xml", "ast_board.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_circuit_board.xml", "ast_circuit_board.tex")
--处理器
local ast_cpu = AddRecipe("ast_cpu",
{Ingredient("coil", 1,"images/inventoryimages/coil.xml", "coil.tex"),Ingredient("ast_circuit_board", 1,"images/inventoryimages/ast_circuit_board.xml", "ast_circuit_board.tex"),Ingredient("ast_memorybank", 1,"images/inventoryimages/ast_memorybank.xml", "ast_memorybank.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_cpu.xml", "ast_cpu.tex")
--内存条
local ast_memorybank = AddRecipe("ast_memorybank",
{Ingredient("ast_board", 1,"images/inventoryimages/ast_board.xml", "ast_board.tex"),Ingredient("culine", 1,"images/inventoryimages/culine.xml", "culine.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_memorybank.xml", "ast_memorybank.tex")
--智能芯片
local ast_ai = AddRecipe("ast_ai",
{Ingredient("ast_board", 1,"images/inventoryimages/ast_board.xml", "ast_board.tex"),Ingredient("unit_center", 1,"images/inventoryimages/unit_center.xml", "unit_center.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_ai.xml", "ast_ai.tex")
--电磁线圈
local coil = AddRecipe("coil",
{Ingredient("ast_gears", 1,"images/inventoryimages/ast_gears.xml", "ast_gears.tex"),Ingredient("culine", 1,"images/inventoryimages/culine.xml", "culine.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/coil.xml", "coil.tex")
--电线
local culine = AddRecipe("culine",
{Ingredient("magicpower", 1,"images/inventoryimages/magicpower.xml", "magicpower.tex"),Ingredient("culine", 1,"images/inventoryimages/culine.xml", "culine.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/culine.xml", "culine.tex")
--聚焦阵列
local ast_focus = AddRecipe("ast_focus",
{Ingredient("coil", 1,"images/inventoryimages/coil.xml", "coil.tex"),Ingredient("ast_board", 1,"images/inventoryimages/ast_board.xml", "ast_board.tex"),Ingredient("ast_gears", 1,"images/inventoryimages/ast_gears.xml", "ast_gears.tex")},
ASTtab,TECH.TOU_ASTITEM_TWO,
nil, nil, true, nil, "ast_builder",
"images/inventoryimages/ast_focus.xml", "ast_focus.tex")
--分解机
local millbox = AddRecipe("millbox",
{Ingredient("magicpower_mk2", 1,"images/inventoryimages/magicpower_mk2.xml", "magicpower_mk2.tex"),Ingredient("bmachineshell", 1,"images/inventoryimages/bmachineshell.xml", "bmachineshell.tex"),Ingredient("unit_center", 1,"images/inventoryimages/unit_center.xml", "unit_center.tex")},
ITEMtab,TECH.SCIENCE_ONE,
"millbox_placer", 1.5, nil, nil, "item_builder",
"images/inventoryimages/millbox.xml", "millbox.tex")
--魔力汲取器
local magicbox = AddRecipe("magicbox",
{Ingredient("magicpower_mk2", 1,"images/inventoryimages/magicpower_mk2.xml", "magicpower_mk2.tex"),Ingredient("bmachineshell", 1,"images/inventoryimages/bmachineshell.xml", "bmachineshell.tex"),Ingredient("unit_center", 1,"images/inventoryimages/unit_center.xml", "unit_center.tex")},
ITEMtab,TECH.SCIENCE_ONE,
"magicbox_placer", 1.5, nil, nil, "item_builder",
"images/inventoryimages/magicbox.xml", "magicbox.tex")
--树箱
local treebox = AddRecipe("treebox",
{Ingredient("gears",2),Ingredient("bmachineshell", 1,"images/inventoryimages/bmachineshell.xml", "bmachineshell.tex"),Ingredient("unit_center", 1,"images/inventoryimages/unit_center.xml", "unit_center.tex")},
ITEMtab,TECH.SCIENCE_ONE,
"treebox_placer", 1.5, nil, nil, "item_builder",
"images/inventoryimages/treebox.xml", "treebox.tex")
--压缩机
local compressor = AddRecipe("compressor",
{Ingredient("transistor", 4),Ingredient("bmachineshell", 1,"images/inventoryimages/bmachineshell.xml", "bmachineshell.tex"),Ingredient("unit_center", 1,"images/inventoryimages/unit_center.xml", "unit_center.tex")},
ITEMtab,TECH.SCIENCE_ONE,
"compressor_placer", 1.5, nil, nil, "item_builder",
"images/inventoryimages/compressor.xml", "compressor.tex")
--给原版物品做修改
AddPrefabPostInit("log", function(inst)
inst:AddComponent("tradable")
end)
AddPrefabPostInit("poop", function(inst)
inst:AddComponent("tradable")
end)
AddPrefabPostInit("marble", function(inst)
inst:AddComponent("tradable")
end)
AddPrefabPostInit("cutreeds", function(inst)
inst:AddComponent("tradable")
end)
AddPrefabPostInit("turf_desertdirt", function(inst)
inst:AddComponent("tradable")
end)
--鬣狗丘周围生长骨竹
AddPrefabPostInit("houndmound", function(inst)

local function OnIsDay(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
	local xx = math.random(-5,5)
	local zz = math.random(-5,5)
	local yy = math.random(0,9)
    if yy == 0
then
	x = x+xx
	z = z+zz
	SpawnPrefab("guzhu").Transform:SetPosition(x, y, z)
	end
end
inst:WatchWorldState("isday", OnIsDay)
end)
--岩浆池周围长永燃矿
AddPrefabPostInit("lava_pond", function(inst)

local function SeasonalSpawnChanges(inst,season)
    local x, y, z = inst.Transform:GetWorldPosition()
	local xxx = math.random(-5,5)
	local zzz = math.random(-5,5)
	if season == "summer" then
	x = x+xxx
	z = z+zzz
	SpawnPrefab("firestone").Transform:SetPosition(x, y, z)
	end
end

inst:WatchWorldState("season", SeasonalSpawnChanges,TheWorld )
end)
--[[月台降临厄尔吉斯之眼
AddPrefabPostInit("moonbase", function(inst)

local function SeasonalSpawnChanges(inst,season)
    local x, y, z = inst.Transform:GetWorldPosition()
	local xx = math.random(-5,5)
	local zz = math.random(-5,5)
	if season == "spring" then
	x = x+xx
	z = z+zz
	SpawnPrefab("moonghost").Transform:SetPosition(x, y, z)
	SpawnPrefab("moonmonster",15).Transform:SetPosition(x,y,z+2)
	end
end
inst:WatchWorldState("season", SeasonalSpawnChanges,TheWorld )

end)]]
--[[图鉴ui
local containers = require "containers"

local params = {}

local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab, data, ...)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
    else
        containers_widgetsetup_base(container, prefab, data, ...)
    end
end

local function makeChest()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_tujian_3x3",
            animbuild = "ui_tujian_3x3",
            pos = Vector3(0, 200, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }

    for y = 2, 0, -1 do
        for x = 0, 2 do
            table.insert(container.widget.slotpos, Vector3(80 * x - 80 * 2 + 80, 80 * y - 80 * 2 + 80, 0))
        end
    end

    return container
end

params.tujian = makeChest()
--食材加工台
params.foodworktable =
{
    widget =
    {
        slotpos =
        {
            Vector3(0, 64 + 32 + 8 + 4, 0), 
            Vector3(0, 32 + 4, 0),
         
        },
        animbank = "ui_cookpot_1x4",
        animbuild = "ui_cookpot_1x4",
        pos = Vector3(200, 0, 0),
        side_align_tip = 100,
        buttoninfo =
        {
            text = "加工",
            position = Vector3(0, -140, 0),
        }
    },
    acceptsstacks = true,
    type = "cooker",
}
function params.foodworktable.widget.buttoninfo.fn(inst)
local x, y, z = inst.Transform:GetWorldPosition()
y = 1  x = x+2
--生肉串
if inst.components.container:Has("twigs",1)and inst.components.container:Has("smallmeat", 1) then inst.components.container:ConsumeByName("twigs",1) inst.components.container:ConsumeByName("smallmeat",1)  SpawnPrefab("underboiled_kabobs").Transform:SetPosition(x, y, z) end
--小肉汤
if inst.components.container:Has("water",1 )and inst.components.container:Has("meat", 1) then inst.components.container:ConsumeByName("water",1) inst.components.container:ConsumeByName("meat",1)  SpawnPrefab("smallbonestew").Transform:SetPosition(x, y, z) end
--奶油蛋糕
if inst.components.container:Has("butterflywings",1 )and inst.components.container:Has("dough", 1) then inst.components.container:ConsumeByName("butterflywings",1) inst.components.container:ConsumeByName("dough",1)  SpawnPrefab("butterflymuffin").Transform:SetPosition(x, y, z) end
--大肉汤
if inst.components.container:Has("smallbonestew", 2) then inst.components.container:ConsumeByName("smallbonestew",2) SpawnPrefab("bonestew").Transform:SetPosition(x, y, z) end
--面团
if inst.components.container:Has("flour",1 )and inst.components.container:Has("water", 1) then inst.components.container:ConsumeByName("water",1) inst.components.container:ConsumeByName("flour",1)  SpawnPrefab("dough").Transform:SetPosition(x, y, z) end
 end
for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end
]]
local function widgetcreation(widgetanimbank, widgetpos, slot_x, slot_y, posslot_x, posslot_y)
local params = {}
params.foodworktable =
{
    widget =
    {
        slotpos =
        {
            Vector3(0, 64 + 32 + 8 + 4, 0), 
            Vector3(0, 32 + 4, 0),
         
        },
        animbank = "ui_cookpot_1x4",
        animbuild = "ui_cookpot_1x4",
        pos = Vector3(200, 0, 0),
        side_align_tip = 100,
        buttoninfo =
        {
            text = "加工",
            position = Vector3(0, -140, 0),
        }
    },
    acceptsstacks = true,
    type = "cooker",	
}
 function params.foodworktable.widget.buttoninfo.fn(inst)
local x, y, z = inst.Transform:GetWorldPosition()
y = 1  x = x+2
--生肉串
if inst.components.container:Has("twigs",1)and inst.components.container:Has("smallmeat", 1) then inst.components.container:ConsumeByName("twigs",1) inst.components.container:ConsumeByName("smallmeat",1)  SpawnPrefab("underboiled_kabobs").Transform:SetPosition(x, y, z) end
--小肉汤
if inst.components.container:Has("water",1 )and inst.components.container:Has("meat", 1) then inst.components.container:ConsumeByName("water",1) inst.components.container:ConsumeByName("meat",1)  SpawnPrefab("smallbonestew").Transform:SetPosition(x, y, z) end
--奶油蛋糕
if inst.components.container:Has("butterflywings",1 )and inst.components.container:Has("dough", 1) then inst.components.container:ConsumeByName("butterflywings",1) inst.components.container:ConsumeByName("dough",1)  SpawnPrefab("butterflymuffin").Transform:SetPosition(x, y, z) end
--大肉汤
if inst.components.container:Has("smallbonestew", 2) then inst.components.container:ConsumeByName("smallbonestew",2) SpawnPrefab("bonestew").Transform:SetPosition(x, y, z) end
--面团
if inst.components.container:Has("flour",1 )and inst.components.container:Has("water", 1) then inst.components.container:ConsumeByName("water",1) inst.components.container:ConsumeByName("flour",1)  SpawnPrefab("dough").Transform:SetPosition(x, y, z) end
 end

params.tujian =
{
        widget =
        {
            slotpos = {},
            animbank = "ui_tujian_3x3",
            animbuild = "ui_tujian_3x3",
            pos = Vector3(0, 200, 0),
            side_align_tip = 160,
        },
        type = "chest",
}	
    for y = 2, 0, -1 do
        for x = 0, 2 do
            table.insert(params.tujian.widget.slotpos, Vector3(80 * x - 80 * 2 + 80, 80 * y - 80 * 2 + 80, 0))
        end
    end
	local containers = GLOBAL.require "containers"
	local iii_old_widgetsetup = containers.widgetsetup
	function containers.widgetsetup(container, prefab, data)
		local pref = prefab or container.inst.prefab
		if pref == "tujian"  or pref == "foodworktable"  then
			local t = params[pref]
			if t ~= nil then
				for k, v in pairs(t) do
					container[k] = v
				end
			container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
			end
		else
			return iii_old_widgetsetup(container, prefab)
		end
	end
	end
widgetcreation(widgetanimbank, widgetpos, slot_x, slot_y, posslot_x, posslot_y)

--标题图标啥啥的
STRINGS.CHARACTERS.TOBIICHIORIGAMI = require "speech_tobiichiorigami"
STRINGS.NAMES.TOBIICHIORIGAMI = "Esc"
AddMinimapAtlas("images/map_icons/tobiichiorigami.xml")
AddModCharacter("tobiichiorigami")
--动作
GLOBAL.ACTIONS.LOOKAT.fn=function(act)
    local targ = act.target or act.invobject
    
    if targ ~= nil and targ.components.inspectable ~= nil then
	    if targ.prefab == "ast_2" or targ.prefab == "ast" then targ.components.inspectable:GetDescription(act.doer) 
		else
            local desc = targ.components.inspectable:GetDescription(act.doer)
            if desc ~= nil then
                if act.doer.components.playercontroller == nil or
                not act.doer.components.playercontroller.directwalking then
                act.doer.components.locomotor:Stop()
            end
            if act.doer.components.talker ~= nil then
                act.doer.components.talker:Say(desc, 2.5, targ.components.inspectable.noanim)
            end
            return true
        end
end
end
end